library(raster)
library(scales)

csvDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 5 - BESE transects/CSV/'
NDVIDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 5 - BESE transects/NDVI/'
AHNSiteDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 5 - BESE transects/AHN/'
figureDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 5 - BESE transects/Figure components/'

# GPS Coordinate information
setwd(NDVIDirectory)
NDVI = raster('v_Westerschelde_2010_NDVI_Paulina.tif')
#rSub = crop(r, extent(r, 1338,1400, 1170, 1250))
yPos = 375100
xPos = 38825
main = 'Paulina'
xlim = c(38800,39600)
breaks = c(-0.16,0.1,1)
scaleBarxy = c(39450, 375250)

pch = c(21,23,22)
bg = alpha(c('green', 'black','grey'),0.5)
col = alpha(c('darkgreen','black','black'),1)

setwd(AHNSiteDirectory)
r1 = raster(dir(pattern = '.tif')[1])
r2 = raster(dir(pattern = '.tif')[2])
r3 = merge(r1,r2)
r4 = crop(r3, NDVI)

d = read.csv('inundationDuration_perc.csv')
e = read.csv('elevation_cm.csv')
inundationFreq = d$V3
elevation.cm = e$V3
elevation.m = elevation.cm/100
M = as.matrix(r4)

# ------------

# --- Recalculate inundation frequency
i_row = 1
i_col = 1
inundFreqM = M
inundFreqM[] = NA
for(i_col in 1:dim(M)[2]){
  for(i_row in 1:dim(M)[1]){
    if(!is.na(M[i_row,i_col])){
      inundFreqM[i_row,i_col] = inundationFreq[which.min(abs(M[i_row,i_col] - elevation.m))]
    }
  }
}
inundFreqR = setExtent(raster(inundFreqM), ext = extent(r4))

# Plot raster background ----------------------------
tiff('Figure 5b.tif', width = 20, height = 20, units = "cm", res = 300)

colPallete = colorRampPalette(alpha(c('white',grey(0.35)),0.5))
colSeq = colPallete(3)
plot(NDVI, breaks = breaks, col = colSeq, bty = 'n', 
     xaxt = 'n', yaxt = 'n', box = F,
     main = main, legend = F,
     xlim = xlim)
contour(inundFreqR, levels = seq(0,100, 10), add = T, vfont = c("sans serif", "bold"),
        labcex = 1.3, col = alpha('black',1), lwd = 1.2, lty = 3)
scalebar(d = 100, label = '100 m', xy = scaleBarxy, cex = 1.3)

# Saltmarsh & seagrass mimic survey
setwd(csvDirectory)
d = read.csv('Bivalve survey all marshes with AHN inundation.csv')

d = d[d$site == 'Paulina',]
d$habitat = factor(d$habitat)
d$sample.ID = factor(d$sample.ID)
d$mass.g[d$species == 'Mytilus edulis' & !is.na(d$length.mm)] = 8.6887e-05 * d$length.mm[d$species == 'Mytilus edulis' & !is.na(d$length.mm)] ^2.8832
d$mass.g[d$species == 'Crassostrea gigas' & !is.na(d$length.mm)] = 0.0001116122 * d$length.mm[d$species == 'Crassostrea gigas' & !is.na(d$length.mm)] ^2.84053

massDensity.g = tapply(d$mass.g, d$sample.ID, sum, na.rm = T)
sampleArea.m2 = tapply(d$sampleArea.m2, d$sample.ID, unique)
massDensity.g_m2 = massDensity.g/sampleArea.m2
habitat = factor(levels(d$habitat)[tapply(d$habitat, d$sample.ID, unique)])
x = tapply(d$X_RD, d$sample.ID, unique)
y = tapply(d$Y_RD, d$sample.ID, unique)

pointScaleParameter = 250
legendSeq = c(2,3,4)
pointScale = sqrt(massDensity.g_m2/pointScaleParameter)
points(y[massDensity.g_m2 == 0] ~ x[massDensity.g_m2 == 0], 
       pch = 4, cex = 1, col = 'darkgreen', lwd = 2)
filter = T#habitat != 'seagrass mimic'
bg = alpha(c('green','darkblue'),0.5)
points(y[filter] ~ x[filter], pch = 21, 
       bg = bg[habitat], #alpha('red',0.5),
       col = 1,
       cex = pointScale)

# BESE Transect
setwd(csvDirectory)
d = read.csv('bivalve_transect_data_complete.csv')
d = d[d$species == 'Mytilus edulis' | d$species == 'Crassostrea gigas',]
d = d[d$site == 'Paulina',]

d$mass.g[d$species == 'Crassostrea gigas'] = 0.0001116122 * d$length.mm[d$species == 'Crassostrea gigas'] ^2.84053
d$mass.g[d$species == 'Mytilus edulis'] = 8.6887e-05 * d$length.mm[d$species == 'Mytilus edulis'] ^2.8832

massDensity.g = as.numeric(tapply(d$mass.g, d$transect_position, sum))
sampleArea.m2 = as.numeric(tapply(d$sampleArea.m2, d$transect_position, unique))
massDensity.g_m2 = massDensity.g/sampleArea.m2
inundFreq = as.numeric(tapply(d$inund_freq.perc, d$transect_position, unique))
X = as.numeric(tapply(d$X, d$transect_position, unique))
Y = as.numeric(tapply(d$Y, d$transect_position, unique))
Y2 = sort(Y)
X2 = X[order(Y)]
pointScale = sqrt(massDensity.g_m2/pointScaleParameter)
points(Y2 ~ X2, cex = pointScale, pch = 21, bg = alpha(grey(0.2),0.3), col = 1)
points(Y2[massDensity.g_m2 == 0] ~ X2[massDensity.g_m2 == 0],
       pch = 4, cex = 0.5, col = 'black')

# Legend ---------

pointLegend = sqrt(10^legendSeq/pointScaleParameter)
rect(xleft = xPos - 10, xright = xPos + 155, ybottom = yPos - 40, ytop = yPos + 180, col = 'white')
offset = c(-10, 25,50,120)#seq(-30,110,length.out = 5) 
points(x = rep(xPos + 40, times = 4), y = yPos + offset[2:5],
       cex = pointLegend,
       pch = 21, bg = alpha('green',0.5), col = 'darkgreen')
points(x = xPos + 40, y = yPos + -10,
       pch = 4, cex = 1, lwd = 2, col = 'darkgreen')
text = c(0,
         expression('10'^'2'),
         expression('10'^'3'),
         expression('10'^'4'))
offset = c(-5, 30,65,110)
text(x = xPos + 110, y = yPos + 150, expression(g/m^2), cex = 1.3)
text(x = rep(xPos + 105, times = 4), 
     y = c(yPos + offset[1], yPos + offset[2], yPos + offset[3], yPos + offset[4]), 
     cex = 1.3,
     text)


text(y = mean(y) + 60, x = mean(x) + 20, 'Seagrass mimics', cex = 1.3)
lines(y = c(y[habitat == 'seagrass mimic'][1], mean(y) + 80), x = c(x[habitat == 'seagrass mimic'][1], mean(x) - 30))

text(y = mean(y) + 310, x = mean(x) + 180, 'Lattice structures', cex = 1.3)
lines(y = c(Y2[1], Y2[11]) - 50, x = c(X2[1], X2[11]) + 50)
lines(y = c(Y2[1], Y2[1] + 10) - 50, x = c(X2[1], X2[1] - 10) + 50)
lines(y = c(Y2[11], Y2[11] + 10) - 50, x = c(X2[11], X2[11] - 10) + 50)
lines(y = c(Y2[3] - 50, Y2[2] - 40), x = c(X2[3] + 50, X2[2] + 130))
setwd(figureDirectory)
dev.off()


# ------------------------
# ------------------------

# Inundation v mass density plot

tiff('Figure 5a.tif', width = 20, height = 17, units = "cm", res = 300)

# BESE Transect
setwd(csvDirectory)
d = read.csv('bivalve_transect_data_complete.csv')
d = d[d$species == 'Mytilus edulis' | d$species == 'Crassostrea gigas',]
d = d[d$site == 'Paulina',]

d$mass.g[d$species == 'Crassostrea gigas'] = 0.0001116122 * d$length.mm[d$species == 'Crassostrea gigas'] ^2.84053
d$mass.g[d$species == 'Mytilus edulis'] = 8.6887e-05 * d$length.mm[d$species == 'Mytilus edulis'] ^2.8832

massDensity.g = as.numeric(tapply(d$mass.g, d$transect_position, sum))
sampleArea.m2 = as.numeric(tapply(d$sampleArea.m2, d$transect_position, unique))
massDensity.g_m2 = massDensity.g/sampleArea.m2
inundFreq = as.numeric(tapply(d$inund_freq.perc, d$transect_position, unique))
X = as.numeric(tapply(d$X, d$transect_position, unique))
Y = as.numeric(tapply(d$Y, d$transect_position, unique))
Y2 = sort(Y)
X2 = X[order(Y)]

par(mar = c(5,5,4,4))
plot(massDensity.g_m2 ~ inundFreq, log = 'yx', pch = 21, bg = alpha(grey(0.2),0.5),
     xlim = c(17, 100), ylim = c(1,100000), yaxt = 'n', cex.lab= 1.3, cex.axis = 1.3,
     ylab = expression('Bivavle mass density (g m'^'-2'*')'),
     xlab = 'Inundation Freqeuncy (%)', cex = 1.3)
axis(side = 2, at = 10^seq(0, 5, 1), label = 10^seq(0, 5, 1), cex.axis = 1.3)
m = lm(log(massDensity.g_m2) ~ log(inundFreq))
summary(m)
a = m$coefficients[1]
b = m$coefficients[2]
xv = seq(min(inundFreq), max(inundFreq), length.out = 1000)
yv = exp(a + b*log(xv))
lines(yv ~ xv, col = alpha('grey',0.5), lwd = 3)
lines(yv ~ xv, lty = 2)


for(i in 1:2){
  setwd(csvDirectory)
  d = read.csv('Bivalve survey all marshes with AHN inundation.csv')
  d = d[d$site == 'Paulina',]
  
  if(i == 1){
    d = d[d$habitat != 'seagrass mimic',]
  } else {
    d = d[d$habitat == 'seagrass mimic',]
  }
  d$sample.ID = factor(d$sample.ID)
  d$mass.g[d$species == 'Crassostrea gigas' & !is.na(d$length.mm)] = 0.0001116122 * d$length.mm[d$species == 'Crassostrea gigas' & !is.na(d$length.mm)] ^2.84053
  d$mass.g[d$species == 'Mytilus edulis' & !is.na(d$length.mm)] = 8.6887e-05 * d$length.mm[d$species == 'Mytilus edulis' & !is.na(d$length.mm)] ^2.8832
  massDensity.g = tapply(d$mass.g, d$sample.ID, sum, na.rm = T)
  sampleArea.m2 = tapply(d$sampleArea.m2, d$sample.ID, unique)
  massDensity.g_m2 = massDensity.g/sampleArea.m2
  habitat = factor(levels(d$habitat)[tapply(d$habitat, d$sample.ID, unique)])
  x = tapply(d$X_RD, d$sample.ID, unique)
  y = tapply(d$Y_RD, d$sample.ID, unique)
  
  inundFreq = tapply(d$inundFreq, d$sample.ID, unique)
  massDensity.g_m2 = as.numeric(massDensity.g_m2)
  
  y = tapply(massDensity.g_m2, round(inundFreq,0), mean)
  x = sort(unique(round(inundFreq,0)))
  
  if(i == 1){
    points(y[y > 0] ~ x[y > 0], pch =21, cex = 1.3, bg = alpha('green',0.5))
    m = lm(log(y[y > 0]) ~ log(x[y > 0]))
    summary(m)
    a = m$coefficients[1]
    b = m$coefficients[2]
    xv = seq(min(inundFreq[massDensity.g_m2 > 0], na.rm = T),max(inundFreq[massDensity.g_m2 > 0], na.rm = T), length.out = 1000)
    yv = exp(a + b*log(xv))
    lines(yv ~ xv, col = alpha('green',0.5), lwd = 3)
    lines(yv ~ xv, lty = 2)
  } else {
    points(y[y > 0] ~ x[y > 0], pch =21, cex = 1.3, bg = alpha('blue',0.5))
  }
}
setwd(figureDirectory)
dev.off()
